#/bin/sh

exec_name=omcservice

cur_dir=$(
    cd $(dirname $0)
    pwd
)

function start() {
    export LD_LIBRARY_PATH=$cur_dir/libs:$LD_LIBRARY_PATH
    $cur_dir/$exec_name
}

function stop() {
    killall $exec_name
}

function restart() {
    sleep 2s
    stop
    sleep 2s
    start
}

case "$1" in
start)
    echo "start $exec_name"
    start
    ;;
stop)
    echo "kill $exec_name"
    stop
    ;;
restart)
    echo "restart $exec_name"
    restart
    ;;
*)
    echo "$0 {start|stop|restart}"
    echo "start   ---> start $exec_name"
    echo "stop    ---> stop  $exec_name"
    echo "restart ---> restart  $exec_name"
    exit 1
    ;;
esac

exit $?
